/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.Atom;
import CIspace.planning.BlockGraph;
import CIspace.planning.BlockNode;
import CIspace.planning.LogicParser;
import CIspace.planning.Predicate;
import CIspace.planning.StringConstant;
import CIspace.planning.Term;
import CIspace.planning.Variable;
import java.util.StringTokenizer;
import java.util.Vector;

public class BlockWorldLogicParser
extends LogicParser {
    protected BlockGraph blockGraph;
    protected BlockGraph goalBlockGraph;

    BlockWorldLogicParser(String logicProgram, BlockGraph blockGraph) {
        super(logicProgram);
        this.blockGraph = blockGraph;
    }

    protected Atom parseAtom(String token, Vector variables, Vector constants) {
        Vector<Object> terms = new Vector<Object>();
        String predName = token.substring(0, token.indexOf("("));
        token = token.substring(token.indexOf("(") + 1, token.indexOf(")"));
        StringTokenizer termTokenizer = new StringTokenizer(token, " ,", false);
        while (termTokenizer.hasMoreTokens()) {
            String term = termTokenizer.nextToken();
            String firstChar = term.substring(0, 1);
            if (firstChar.equals(firstChar.toLowerCase())) {
                BlockNode block = this.blockGraph.getBlockByName(term);
                if (block != null) {
                    Term newTerm = new Term(block);
                    terms.addElement(newTerm);
                    continue;
                }
                boolean found = false;
                int i = 0;
                while (i < constants.size()) {
                    Term currTerm = (Term)constants.elementAt(i);
                    if (currTerm.toString().equals(term)) {
                        terms.addElement(currTerm);
                        found = true;
                    }
                    ++i;
                }
                if (found) continue;
                Term newTerm = new Term(new StringConstant(term));
                terms.addElement(newTerm);
                constants.addElement(newTerm);
                continue;
            }
            boolean found = false;
            int i = 0;
            while (i < variables.size()) {
                Variable currVar = (Variable)variables.elementAt(i);
                if (currVar.toString().equals(term)) {
                    terms.addElement(currVar);
                    found = true;
                }
                ++i;
            }
            if (found) continue;
            Term newTerm = new Term(new Variable(term));
            terms.addElement(newTerm);
            constants.addElement(newTerm);
        }
        Atom newAtom = new Atom(new Predicate(predName, terms.size()));
        int i = 0;
        while (i < terms.size()) {
            newAtom.setTerm(i, terms.elementAt(i));
            ++i;
        }
        return newAtom;
    }
}

