/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.graphToolKit.MessageDialog;
import CIspace.planning.BlockGraph;
import CIspace.planning.BlockNode;
import CIspace.planning.DialogAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BlockPropertiesDialog
extends DialogAdapter {
    protected BlockNode block;
    protected BlockGraph blockGraph;
    protected JFrame window;
    protected boolean isNewBlock;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JComboBox coloursChoice;
    protected JTextField labelText;

    public BlockPropertiesDialog(JFrame parent, BlockGraph graph, BlockNode block, boolean isNewBlock) {
        super(parent, "Block Properties", true);
        this.block = block;
        this.blockGraph = graph;
        this.isNewBlock = isNewBlock;
        this.window = parent;
        this.buildDialog();
        this.pack();
        ((Component)this).setSize(175, 125);
        this.centerWindow();
        this.show();
    }

    private void buildDialog() {
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        JPanel mainPanel = new JPanel();
        this.labelText = new JTextField();
        this.labelText.setText(this.block.getBlockName());
        this.coloursChoice = new JComboBox();
        this.coloursChoice.addItem("Red");
        this.coloursChoice.addItem("Blue");
        this.coloursChoice.addItem("Green");
        this.coloursChoice.addItem("Black");
        this.coloursChoice.addItem("Orange");
        this.coloursChoice.addItem("Gray");
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton("Ok");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        this.addComponent(new JLabel("Label"), mainPanel, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.labelText, mainPanel, 0, 1, 1, 1, 0.0, 0.0);
        this.addComponent(new JLabel("Colour"), mainPanel, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.coloursChoice, mainPanel, 1, 1, 1, 1, 0.0, 0.0);
        this.addComponent(buttonPanel, mainPanel, 2, 0, 2, 1, 0.0, 0.0);
        mainPanel.setLayout(this.gbl);
        this.getContentPane().add(mainPanel);
    }

    protected void validateAndProcessInput() {
        Color newColour;
        String newLabel = this.labelText.getText();
        if (this.isNewBlock) {
            if (!this.blockGraph.checkNewLabel(newLabel)) {
                MessageDialog mDialog = new MessageDialog(this.window);
                mDialog.open("Invalid Label", "Please specify a unique block label that starts with a lower-case letter.");
                return;
            }
        } else if (!newLabel.equals(this.block.getBlockName()) && !this.blockGraph.checkNewLabel(newLabel)) {
            MessageDialog mDialog = new MessageDialog(this.window);
            mDialog.open("Invalid Label", "Please specify a unique block label that starts with a lower-case letter.");
            return;
        }
        if (this.coloursChoice.getSelectedItem() == "Green") {
            newColour = Color.green.darker();
            this.block.setColourName("green");
        } else if (this.coloursChoice.getSelectedItem() == "Red") {
            newColour = Color.red.darker();
            this.block.setColourName("red");
        } else if (this.coloursChoice.getSelectedItem() == "Blue") {
            newColour = Color.blue;
            this.block.setColourName("blue");
        } else if (this.coloursChoice.getSelectedItem() == "Cyan") {
            newColour = Color.cyan;
            this.block.setColourName("cyan");
        } else if (this.coloursChoice.getSelectedItem() == "Gray") {
            newColour = Color.gray;
            this.block.setColourName("gray");
        } else if (this.coloursChoice.getSelectedItem() == "Orange") {
            newColour = Color.orange;
            this.block.setColourName("orange");
        } else {
            newColour = Color.black;
            this.block.setColourName("black");
        }
        this.block.color = newColour;
        this.block.setLabel(newLabel);
        this.block.setBlockName(newLabel);
        if (this.isNewBlock) {
            this.blockGraph.addBlock(this.block);
        }
        this.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Ok") {
            this.validateAndProcessInput();
        } else if (e.getActionCommand() == "Cancel") {
            this.dispose();
        }
    }
}

