/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.Point;
import CIspace.planning.AnimatedEntity;
import CIspace.planning.BlockGraph;
import CIspace.planning.Constant;
import java.awt.Color;
import java.awt.Graphics;

public class BlockNode
extends Node
implements Constant,
Cloneable,
AnimatedEntity {
    protected int column = 0;
    protected int stackHeight = 0;
    protected String blockName;
    protected boolean isAnimating;
    protected int lastBlockSize;
    protected Point lastTablePoint;
    protected String colourName;

    public BlockNode(BlockGraph graph) {
        super(graph);
        this.setBlockName("");
        this.isAnimating = false;
        this.colourName = "N/A";
        this.lastTablePoint = new Point();
    }

    public BlockNode(Graph graph, String label, Point pos, Color color, int shape) {
        super(graph, label, pos, color, shape);
        this.setBlockName(label);
        this.isAnimating = false;
        this.colourName = "N/A";
        this.lastTablePoint = new Point();
    }

    public Point getGridPosition(Point tablePoint, int blockSize) {
        float lw = this.graph.getLineWidth() + (float)this.xw;
        Point nw = new Point();
        nw.x = tablePoint.x + (float)(this.column * blockSize);
        nw.y = tablePoint.y - (float)blockSize - ((float)blockSize + lw) * (float)this.stackHeight;
        Point currPos = new Point(nw.x + (float)(blockSize / 2), nw.y + (float)(blockSize / 2) - lw);
        return currPos;
    }

    public float getGridY() {
        float lw = this.graph.getLineWidth() + (float)this.xw;
        Point nw = new Point();
        nw.y = this.lastTablePoint.y - (float)this.lastBlockSize - ((float)this.lastBlockSize + lw) * (float)this.stackHeight;
        return nw.y + (float)(this.lastBlockSize / 2) - lw;
    }

    public float getGridX() {
        Point nw = new Point();
        nw.x = this.lastTablePoint.x + (float)(this.column * this.lastBlockSize);
        return nw.x + (float)(this.lastBlockSize / 2);
    }

    public void draw(Graphics g, boolean moving, Point tablePoint, int blockSize) {
        this.lastBlockSize = blockSize;
        this.lastTablePoint = tablePoint;
        float lw = this.graph.getLineWidth() + (float)this.xw;
        Point nw = new Point();
        if (!(moving && this.isSelected || this.isAnimating)) {
            nw.x = tablePoint.x + (float)(this.column * blockSize);
            nw.y = tablePoint.y - (float)blockSize - ((float)blockSize + lw) * (float)this.stackHeight;
            this.pos.x = nw.x + (float)(blockSize / 2);
            this.pos.y = nw.y + (float)(blockSize / 2) - lw;
        } else {
            nw = new Point(this.pos);
            nw.translate(-this.width / 2, -this.height / 2);
        }
        this.width = blockSize - 2 * (int)lw;
        this.height = blockSize - (int)lw;
        g.setColor(this.color);
        if (lw == 1.0f) {
            if (this.isBold) {
                g.setColor(this.color);
            } else {
                g.setColor(Color.white);
            }
            g.fillRect((int)nw.x, (int)nw.y, this.width, this.height);
            g.setColor(this.color);
            g.drawRect((int)nw.x, (int)nw.y, this.width, this.height);
        } else {
            g.fillRect((int)(nw.x - lw), (int)(nw.y - lw), (int)((float)this.width + lw * 2.0f), (int)((float)this.height + lw * 2.0f));
            if (!this.isBold) {
                g.setColor(Color.white);
            }
            g.fillRect((int)nw.x, (int)nw.y, this.width, this.height);
        }
        if (!moving) {
            this.drawLabel(g);
        }
    }

    public void setAnimating(boolean isAnimating) {
        this.isAnimating = isAnimating;
    }

    public void updateSize() {
    }

    public String getColourName() {
        return this.colourName;
    }

    public void setColourName(String colourName) {
        this.colourName = colourName;
    }

    public void setStackHeight(int StackHeight) {
        this.stackHeight = StackHeight;
    }

    public int getStackHeight() {
        return this.stackHeight;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public int getColumn() {
        return this.column;
    }

    public void setBlockName(String blockName) {
        this.blockName = blockName;
        this.label[0] = blockName;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public String toString() {
        return this.blockName;
    }

    public Point getPos() {
        return this.pos;
    }
}

