/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.graphToolKit.Entity;
import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.Point;
import CIspace.planning.Atom;
import CIspace.planning.BlockCanvas;
import CIspace.planning.BlockNode;
import CIspace.planning.Predicate;
import CIspace.planning.Term;
import CIspace.planning.World;
import java.awt.Graphics;
import java.util.Vector;

public class BlockGraph
extends Graph
implements Cloneable {
    protected BlockCanvas canvas;
    protected World world;
    protected Point tablePoint;
    protected int blockSize;
    public static final int NUM_COLUMNS = 7;

    public BlockGraph(BlockCanvas canvas, World world) {
        super(canvas);
        this.canvas = canvas;
        this.world = world;
    }

    public void addBlock(BlockNode block) {
        this.setStackHeight(block);
        this.updateWorldForAddNode(block);
        block.setIndex(this.getNextIndex());
        this.nodes.insertElementAt(block, block.index);
    }

    public void loadBlock(BlockNode block) {
        block.setIndex(this.getNextIndex());
        this.nodes.insertElementAt(block, block.index);
    }

    public void removeBlock(BlockNode block) {
        this.updateWorldForRemoveNode(block);
        this.nodes.removeElement(block);
    }

    protected void updateWorldForAddNode(BlockNode block) {
        int itemType = this.canvas.getCurrentView() == 200 ? 200 : 201;
        if (block.getStackHeight() == 0) {
            this.world.addStateItem(this.makeAtom("ontable", new Term(block)), itemType);
        } else {
            BlockNode underBlock = this.getBlock(block.getColumn(), block.getStackHeight() - 1);
            this.world.addStateItem(this.makeAtom("on", new Term(block), new Term(underBlock)), itemType);
            this.world.removeStateItem(this.makeAtom("clear", new Term(underBlock)), itemType);
        }
        this.world.addStateItem(this.makeAtom("clear", new Term(block)), itemType);
    }

    protected void updateWorldForRemoveNode(BlockNode block) {
        int itemType = this.canvas.getCurrentView() == 200 ? 200 : 201;
        BlockNode blockBelow = this.getBlock(block.getColumn(), block.getStackHeight() - 1);
        BlockNode blockAbove = this.getBlock(block.getColumn(), block.getStackHeight() + 1);
        if (blockBelow == null && blockAbove == null) {
            this.world.removeStateItem(this.makeAtom("clear", new Term(block)), itemType);
            this.world.removeStateItem(this.makeAtom("ontable", new Term(block)), itemType);
        } else if (blockBelow == null && blockAbove != null) {
            this.world.removeStateItem(this.makeAtom("ontable", new Term(block)), itemType);
            this.world.removeStateItem(this.makeAtom("on", new Term(blockAbove), new Term(block)), itemType);
            this.world.addStateItem(this.makeAtom("ontable", new Term(blockAbove)), itemType);
            this.shiftBlocksDown(block.getColumn(), 1);
        } else if (blockBelow != null && blockAbove == null) {
            this.world.removeStateItem(this.makeAtom("clear", new Term(block)), itemType);
            this.world.removeStateItem(this.makeAtom("on", new Term(block), new Term(blockBelow)), itemType);
            this.world.addStateItem(this.makeAtom("clear", new Term(blockBelow)), itemType);
        } else if (blockBelow != null && blockAbove != null) {
            this.world.removeStateItem(this.makeAtom("on", new Term(block), new Term(blockBelow)), itemType);
            this.world.removeStateItem(this.makeAtom("on", new Term(blockAbove), new Term(block)), itemType);
            this.world.addStateItem(this.makeAtom("on", new Term(blockAbove), new Term(blockBelow)), itemType);
            this.shiftBlocksDown(block.getColumn(), block.getStackHeight() + 1);
        }
    }

    protected void shiftBlocksDown(int column, int startHeight) {
        int i = 0;
        while (i < this.nodes.size()) {
            BlockNode currBlock = (BlockNode)this.nodes.elementAt(i);
            if (currBlock.getColumn() == column && currBlock.getStackHeight() >= startHeight) {
                currBlock.setStackHeight(currBlock.getStackHeight() - 1);
            }
            ++i;
        }
    }

    protected Atom makeAtom(String predicate, Term term1) {
        Atom newAtom = new Atom(new Predicate(predicate, 1));
        newAtom.setTerm(0, term1);
        return newAtom;
    }

    protected Atom makeAtom(String predicate, Term term1, Term term2) {
        Atom newAtom = new Atom(new Predicate(predicate, 2));
        newAtom.setTerm(0, term1);
        newAtom.setTerm(1, term2);
        return newAtom;
    }

    protected BlockNode getBlock(int column, int stackHeight) {
        int i = 0;
        while (i < this.nodes.size()) {
            BlockNode currBlock = (BlockNode)this.nodes.elementAt(i);
            if (currBlock.getColumn() == column && currBlock.getStackHeight() == stackHeight) {
                return currBlock;
            }
            ++i;
        }
        return null;
    }

    public BlockNode getHighestBlockInColumn(int column) {
        BlockNode highest = null;
        int i = 0;
        while (i < this.nodes.size()) {
            BlockNode currBlock = (BlockNode)this.nodes.elementAt(i);
            if (currBlock.getColumn() == column) {
                if (highest == null) {
                    highest = currBlock;
                } else if (currBlock.getStackHeight() > highest.getStackHeight()) {
                    highest = currBlock;
                }
            }
            ++i;
        }
        return highest;
    }

    protected void setStackHeight(BlockNode block) {
        int stackHeight = 0;
        int newBlockColumn = block.getColumn();
        int i = 0;
        while (i < this.nodes.size()) {
            int currBlockColumn = ((BlockNode)this.nodes.elementAt((int)i)).column;
            if (currBlockColumn == newBlockColumn) {
                ++stackHeight;
            }
            ++i;
        }
        block.setStackHeight(stackHeight);
    }

    public boolean checkNewLabel(String newLabel) {
        int i = 0;
        while (i < this.nodes.size()) {
            String currBlockLabel = ((BlockNode)this.nodes.elementAt(i)).getBlockName();
            if (currBlockLabel.equals(newLabel)) {
                return false;
            }
            ++i;
        }
        if (newLabel.equals("")) {
            return false;
        }
        String firstChar = newLabel.substring(0, 1);
        return firstChar.equals(firstChar.toLowerCase());
    }

    public String getNewLabel() {
        String newLabel = "";
        int number = this.nodes.size() + 1;
        newLabel = "block" + new Integer(number).toString();
        while (!this.checkNewLabel(newLabel)) {
            newLabel = "block" + new Integer(number).toString();
            ++number;
        }
        return newLabel;
    }

    public void draw(Graphics offscreen, boolean moving) {
        int i = this.numNodes() - 1;
        while (i >= 0) {
            ((BlockNode)this.nodeAt(i)).draw(offscreen, moving, this.tablePoint, this.blockSize);
            --i;
        }
    }

    public boolean select(Entity ent) {
        this.deselectAll();
        if (ent.type == 7772) {
            this.deselectAll();
            return true;
        }
        if (!ent.isSelected) {
            if (ent.type == 7770) {
                this.selectedNodes.addElement(ent);
            } else if (ent.type == 7771) {
                this.selectedEdges.addElement(ent);
            }
            ent.isSelected = true;
        }
        return true;
    }

    public void removeAll() {
        this.nodes = new Vector(10, 10);
    }

    public void setTablePoint(Point point) {
        this.tablePoint = point;
    }

    public void setBlockSize(int size) {
        this.blockSize = size;
    }

    protected BlockNode getBlockByName(String blockName) {
        int i = 0;
        while (i < this.nodes.size()) {
            if (((BlockNode)this.nodes.elementAt(i)).getBlockName().equals(blockName)) {
                return (BlockNode)this.nodes.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public float getHighestBlockY(int col1, int col2, BlockNode targetBlock) {
        float highest = this.tablePoint.y;
        if (col1 > col2) {
            int temp = col1;
            col1 = col2;
            col2 = temp;
        }
        int i = 0;
        while (i < this.nodes.size()) {
            float currNodeY;
            BlockNode currNode = (BlockNode)this.nodes.elementAt(i);
            int currNodeCol = currNode.getColumn();
            if (currNodeCol >= col1 && currNodeCol <= col2 && (targetBlock == null || currNode != targetBlock) && (currNodeY = currNode.getGridY()) < highest) {
                highest = currNodeY;
            }
            ++i;
        }
        return highest;
    }

    public BlockGraph pseudoCopy(BlockCanvas canvas, World world) {
        BlockGraph newGraph = new BlockGraph(canvas, world);
        newGraph.tablePoint = this.tablePoint;
        newGraph.blockSize = this.blockSize;
        int i = 0;
        while (i < this.nodes.size()) {
            BlockNode currBlock = (BlockNode)this.nodes.elementAt(i);
            BlockNode newBlock = new BlockNode(newGraph);
            newBlock.color = currBlock.color;
            newBlock.column = currBlock.column;
            newBlock.height = currBlock.height;
            newBlock.isAnimating = currBlock.isAnimating;
            newBlock.label = currBlock.label;
            newBlock.pos = new Point();
            newBlock.shape = currBlock.shape;
            newBlock.stackHeight = currBlock.stackHeight;
            newBlock.type = currBlock.type;
            newBlock.width = currBlock.width;
            newBlock.xw = currBlock.xw;
            newBlock.blockName = currBlock.blockName;
            newGraph.nodes.addElement(newBlock);
            ++i;
        }
        return newGraph;
    }

    public Vector getBlocks() {
        return this.nodes;
    }
}

