/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.graphToolKit.Entity;
import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.Point;
import CIspace.planning.BlockGraph;
import CIspace.planning.BlockNode;
import CIspace.planning.BlockPropertiesDialog;
import CIspace.planning.BlockWorldProblemParser;
import CIspace.planning.ConfirmContinueDialog;
import CIspace.planning.PlanningWindow;
import CIspace.planning.World;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;

public class BlockCanvas
extends GraphCanvas {
    protected PlanningWindow window;
    protected static final int TABLE_TOP_THICKNESS = 10;
    protected static final int TABLE_HEIGHT = 50;
    protected static final int TABLE_LEG_WIDTH = 15;
    protected static final double TABLE_LENGTH_RATIO = 0.8;
    public static final int CREATE_BLOCK = 100;
    public static final int DELETE_BLOCK = 101;
    public static final int SET_BLOCK_PROPERTIES = 102;
    public static final int INITIAL_STATE = 200;
    public static final int GOAL_STATE = 201;
    protected int tableLength;
    protected BlockGraph initialBlockGraph;
    protected BlockGraph goalBlockGraph;
    protected BlockGraph blockGraph;
    protected World world;
    protected int currentView;
    protected int createSubMode;
    protected int blockCanvasMode;
    protected boolean goalStateValid;
    protected boolean enableGoalReset;
    protected BlockNode lastBlockPressed;

    public BlockCanvas(PlanningWindow parent, boolean inline, World world) {
        super(parent, inline);
        this.window = parent;
        this.world = world;
        this.initialBlockGraph = new BlockGraph(this, world);
        this.goalBlockGraph = new BlockGraph(this, world);
        this.graph = this.initialBlockGraph;
        this.blockGraph = (BlockGraph)this.graph;
        this.setSubmode(3332);
        this.setBlockCanvasMode(100);
        this.tableLength = (int)Math.round((double)this.getWidth() * 0.8);
        this.currentView = 200;
        this.createSubMode = 200;
        this.goalStateValid = false;
        this.enableGoalReset = true;
        this.lastBlockPressed = null;
    }

    public Entity mClicked(MouseEvent e, boolean ctrlDown) {
        Entity ent = super.mClicked(e, ctrlDown);
        if (this.mode == 2220) {
            if (ent == null && e.getModifiers() != 4) {
                this.handleEmptyCanvasLeftClick(e, ent);
            } else if (ent != null && e.getModifiers() != 4) {
                this.handleBlockLeftClick(e, ent);
            }
        }
        return ent;
    }

    protected void handleBlockLeftClick(MouseEvent mouseEvent, Entity entity) {
        if (this.blockCanvasMode == 101 && this.currentView == 200) {
            this.deleteBlock((BlockNode)entity);
        } else if (this.blockCanvasMode == 102 && this.currentView == 200) {
            this.setBlockProperties((BlockNode)entity, false);
        }
    }

    protected void handleEmptyCanvasLeftClick(MouseEvent mouseEvent, Entity entity) {
        if (this.blockCanvasMode == 100 && this.currentView == 200) {
            this.createBlock(new Point(mouseEvent.getX(), mouseEvent.getY()), false);
        }
    }

    protected boolean confirmGoalReset() {
        ConfirmContinueDialog ccd = new ConfirmContinueDialog(this.window, "Warning", "Changing the initial state will reset the goal state. Are you sure you want to continue?", 3, 40);
        return ccd.getResult() == 101;
    }

    protected void popupCanvas(int x, int y) {
        System.out.println("canvas");
        this.pop.setBorder(BorderFactory.createTitledBorder("Create Options"));
        this.pop.removeAll();
        if (this.window.goalStateButton.isSelected()) {
            this.pop.add(this.newJMenuItem("Reorder Goals", this.window));
        } else {
            this.pop.add(this.newJMenuItem("Create New Block", this));
            this.pop.add(this.newJMenuItem("Reorder Goals", this.window));
        }
        this.pop.show(this, x, y);
    }

    protected void popupNode(int x, int y) {
        this.pop.setBorder(BorderFactory.createTitledBorder("Block Options"));
        this.pop.removeAll();
        this.pop.add(this.newJMenuItem("Delete Block", this, this.createSubMode == 200));
        this.pop.add(this.newJMenuItem("Set Block Properties", this, this.createSubMode == 200));
        this.pop.show(this, x, y);
    }

    private JMenuItem newJMenuItem(String label) {
        JMenuItem mItem = new JMenuItem(label);
        mItem.addActionListener(this);
        return mItem;
    }

    private JMenuItem newJMenuItem(String label, String actionCommand, ActionListener listener) {
        JMenuItem mItem = new JMenuItem(label);
        mItem.setActionCommand(actionCommand);
        mItem.addActionListener(listener);
        return mItem;
    }

    private JMenuItem newJMenuItem(String label, ActionListener listener) {
        JMenuItem mItem = new JMenuItem(label);
        mItem.setActionCommand(label);
        mItem.addActionListener(listener);
        return mItem;
    }

    private JMenuItem newJMenuItem(String label, ActionListener listener, boolean isEnabled) {
        JMenuItem mItem = new JMenuItem(label);
        mItem.setActionCommand(label);
        mItem.addActionListener(listener);
        mItem.setEnabled(isEnabled);
        return mItem;
    }

    protected void popupEdge(int x, int y) {
    }

    public void mouseClicked(MouseEvent e, boolean ctrlDown) {
        if (!(this.pause && e.getModifiers() != 4 || e.getModifiers() == 8)) {
            this.mClicked(e, ctrlDown);
        }
    }

    protected void aPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("Delete Block")) {
            this.deleteBlock((BlockNode)this.entClicked);
        }
        if (arg.equals("Set Block Properties")) {
            this.setBlockProperties((BlockNode)this.entClicked, false);
        }
        if (arg.equals("Create New Block")) {
            this.createBlock(this.mClickedPos, true);
        }
        this.graph.deselectAll();
    }

    protected void deleteBlock(BlockNode block) {
        if (this.goalStateValid && this.enableGoalReset && !this.confirmGoalReset()) {
            return;
        }
        this.blockGraph.removeBlock(block);
        this.setGoalStateValid(false);
        if (this.enableGoalReset) {
            this.world.clearState(201);
        }
    }

    protected void createBlock(Point clickPoint, boolean adjustPoint) {
        if (this.goalStateValid && this.enableGoalReset && !this.confirmGoalReset()) {
            return;
        }
        Point pos = new Point((int)clickPoint.x, (int)clickPoint.y);
        BlockNode block = new BlockNode(this.graph, this.blockGraph.getNewLabel(), pos, Color.red, 1111);
        block.height = block.width = Math.round(this.tableLength / 7 / 2);
        this.setColumn(block, (int)clickPoint.x);
        this.setGoalStateValid(false);
        if (this.enableGoalReset) {
            this.world.clearState(201);
        }
        BlockPropertiesDialog bpd = new BlockPropertiesDialog(this.window, this.blockGraph, block, true);
    }

    protected void setBlockProperties(BlockNode block, boolean isNewBlock) {
        if (this.goalStateValid && this.enableGoalReset && !this.confirmGoalReset()) {
            return;
        }
        BlockPropertiesDialog bpd = new BlockPropertiesDialog(this.window, this.blockGraph, block, isNewBlock);
        this.setGoalStateValid(false);
        if (this.enableGoalReset) {
            this.world.clearState(201);
        }
    }

    private void setColumn(BlockNode block, int requestedX) {
        int blockWidth = Math.round(this.tableLength / 7);
        int leftTableX = (this.getWidth() - this.tableLength) / 2;
        if (requestedX < leftTableX) {
            block.setColumn(0);
            return;
        }
        if (requestedX > leftTableX + this.tableLength) {
            block.setColumn(6);
        }
        int currColumnX = leftTableX + blockWidth / 2;
        int col = 0;
        while (currColumnX < leftTableX + this.tableLength) {
            if (Math.abs(currColumnX - requestedX) < blockWidth / 2) {
                block.setColumn(col);
                return;
            }
            ++col;
            currColumnX += blockWidth;
        }
    }

    protected Entity mPressed(MouseEvent e) {
        Entity pressedEntity = super.mPressed(e);
        this.lastBlockPressed = (BlockNode)pressedEntity;
        return pressedEntity;
    }

    protected void mReleased(MouseEvent e) {
        boolean isDragging = this.dragging;
        super.mReleased(e);
        if (isDragging && this.lastBlockPressed != null) {
            this.blockGraph.removeBlock(this.lastBlockPressed);
            this.setColumn(this.lastBlockPressed, e.getX());
            this.blockGraph.addBlock(this.lastBlockPressed);
        }
    }

    public void showInitialState() {
        this.graph = null;
        this.blockGraph = null;
        this.graph = this.initialBlockGraph;
        this.blockGraph = (BlockGraph)this.graph;
        this.currentView = 200;
        this.repaint();
    }

    public void showGoalState() {
        this.graph = null;
        this.blockGraph = null;
        this.graph = this.goalBlockGraph;
        this.blockGraph = (BlockGraph)this.graph;
        this.currentView = 201;
        if (!this.goalStateValid) {
            this.setGoalsToInitialState();
        }
        this.goalStateValid = true;
        this.repaint();
    }

    protected void setGoalsToInitialState() {
        this.goalBlockGraph.removeAll();
        this.world.clearState(201);
        int i = 0;
        while (i < this.initialBlockGraph.numNodes()) {
            BlockNode initialBlock = (BlockNode)this.initialBlockGraph.nodeAt(i);
            BlockNode newBlock = new BlockNode(this.goalBlockGraph, initialBlock.getBlockName(), initialBlock.pos, initialBlock.color, initialBlock.shape);
            newBlock.setColumn(initialBlock.getColumn());
            newBlock.setStackHeight(initialBlock.getStackHeight());
            newBlock.setColourName(initialBlock.getColourName());
            this.goalBlockGraph.addBlock(newBlock);
            ++i;
        }
    }

    public void reset() {
        this.initialBlockGraph.removeAll();
        this.goalBlockGraph.removeAll();
        this.goalStateValid = false;
        this.showInitialState();
        this.createSubMode = 200;
        this.clearMouse();
        this.repaint();
    }

    public void pause() {
        this.pause = true;
    }

    public void unpause() {
        this.pause = false;
    }

    public Vector getInitialBlocks() {
        return this.initialBlockGraph.getBlocks();
    }

    public String getXML(String problemName) {
        BlockNode currNode;
        int i;
        StringBuffer output = new StringBuffer("");
        output.append("<?xml version=\"1.0\" ?>\n\n");
        output.append("<PPIF version=\"0.01\">\n");
        output.append("<Problem>\n");
        output.append("<Name>" + problemName + "</Name>\n");
        output.append("<Domain>BlockWorld</Domain>\n\n");
        output.append("\n<!-- Initial State Description -->\n");
        output.append("<InitialState>\n");
        output.append(this.world.getInitialStateLogicXML(1));
        if (this.initialBlockGraph.numNodes() > 0) {
            output.append("\n\t<!-- Block Display Information -->\n");
            output.append("\t<BlockWorld>\n");
            i = 0;
            while (i < this.initialBlockGraph.numNodes()) {
                currNode = (BlockNode)this.initialBlockGraph.nodeAt(i);
                output.append("\t\t<Block name=\"" + currNode.getBlockName() + "\" colour=\"" + currNode.getColourName() + "\" column=\"" + currNode.getColumn() + "\" stackHeight=\"" + currNode.getStackHeight() + "\"></Block>\n");
                ++i;
            }
            output.append("\t</BlockWorld>\n");
        }
        output.append("</InitialState>\n");
        output.append("\n\n<!-- Goals -->\n");
        output.append("<Goals>\n");
        output.append(this.world.getGoalStateLogicXML(1));
        if (this.goalBlockGraph.numNodes() > 0) {
            output.append("\n\t<!-- Block Display Information -->\n");
            output.append("\t<BlockWorld>\n");
            i = 0;
            while (i < this.goalBlockGraph.numNodes()) {
                currNode = (BlockNode)this.goalBlockGraph.nodeAt(i);
                output.append("\t\t<Block name=\"" + currNode.getBlockName() + "\" colour=\"" + currNode.getColourName() + "\" column=\"" + currNode.getColumn() + "\" stackHeight=\"" + currNode.getStackHeight() + "\"></Block>\n");
                ++i;
            }
            output.append("\t</BlockWorld>\n");
        }
        output.append("</Goals>\n");
        output.append(this.world.getActionXML(0));
        output.append("</Problem>\n");
        output.append("</PPIF>\n");
        return output.toString();
    }

    public void load(String file) {
        this.reset();
        this.world.resetAllState();
        this.goalStateValid = true;
        BlockWorldProblemParser parser = new BlockWorldProblemParser(file, this.world, this.initialBlockGraph, this.goalBlockGraph);
        parser.parse();
    }

    protected Point getTablePoint() {
        Point tablePoint = new Point();
        int leftRightPad = (this.getWidth() - this.tableLength) / 2;
        tablePoint.y = this.getHeight() - 50 - 10;
        tablePoint.x = leftRightPad;
        return tablePoint;
    }

    public void paintComponent(Graphics g) {
        try {
            this.blockGraph.setTablePoint(new Point(this.getTablePoint().x, this.getTablePoint().y));
        }
        catch (NullPointerException e) {
            System.out.println("Can not set Table Point in BlockCanvas.paintComponent ");
        }
        super.paintComponent(g);
        this.tableLength = (int)Math.round((double)this.getWidth() * 0.8);
        this.blockGraph.setBlockSize(Math.round(this.tableLength / 7));
        if (this.panning || this.zooming) {
            g.setColor(Color.black);
            g.drawRect((int)this.pzRect[0], (int)this.pzRect[1], (int)this.pzRect[2], (int)this.pzRect[3]);
        } else {
            this.blockGraph.draw(g, this.moving);
            if (this.makingEdge == 1 || this.makingEdge == 2) {
                g.setColor(Color.black);
                g.drawLine((int)this.from.pos.x, (int)this.from.pos.y, (int)this.mMovedPos.x, (int)this.mMovedPos.y);
            }
            if (this.makingNode) {
                g.setColor(Color.black);
                g.drawOval((int)this.mPressedPos.x - 30, (int)this.mPressedPos.y - 40, 60, 80);
            }
        }
        this.blockGraph.draw(g, this.moving);
        this.drawTable(g);
    }

    protected void drawTable(Graphics g) {
        g.setColor(Color.black);
        this.tableLength = (int)Math.round((double)this.getWidth() * 0.8);
        int leftRightPad = (this.getWidth() - this.tableLength) / 2;
        g.fillRect(leftRightPad, this.getHeight() - 50 - 10, this.tableLength, 10);
        g.fillRect(2 * leftRightPad, this.getHeight() - 50, 15, 50);
        g.fillRect(leftRightPad + this.tableLength - leftRightPad - 15, this.getHeight() - 50, 15, 50);
    }

    public void centerView() {
    }

    public void setBlockCanvasMode(int mode) {
        this.blockCanvasMode = mode;
    }

    public int getCurrentView() {
        return this.currentView;
    }

    public void setGoalStateValid(boolean isValid) {
        this.goalStateValid = isValid;
    }

    public void enableGoalReset(boolean allowReset) {
        this.enableGoalReset = allowReset;
    }

    public void setCreateSubMode(int mode) {
        this.createSubMode = mode;
    }

    public BlockGraph getInitialGraph() {
        return this.initialBlockGraph;
    }

    public BlockGraph getGoalGraph() {
        return this.goalBlockGraph;
    }

    public void setLineWidth(int width) {
        this.initialBlockGraph.setLineWidth(width);
        this.goalBlockGraph.setLineWidth(width);
    }
}

