/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.graphToolKit.Point;
import CIspace.planning.AnimatedEntity;
import CIspace.planning.Animator;
import CIspace.planning.Atom;
import CIspace.planning.BlockCanvas;
import CIspace.planning.BlockGraph;
import CIspace.planning.BlockNode;
import CIspace.planning.Gripper;
import CIspace.planning.PlanningWindow;
import CIspace.planning.World;
import CIspace.planning.WorldListener;
import java.awt.Graphics;
import java.util.Vector;

public class BlockAnimatorCanvas
extends BlockCanvas
implements WorldListener {
    public static final int CURRENT_STATE_DISPLAY = 300;
    public static final int PLAN_VISUALIZATION = 301;
    protected static final int PUTTING_DOWN = 400;
    protected static final int MOVING_BLOCK = 401;
    protected static final int MOVING_GRIPPER = 402;
    protected World world;
    protected int mode;
    protected int currPlanSteps;
    protected boolean usingStrips = true;
    protected boolean puttingDown;
    protected boolean animating;
    protected Vector moveBlockQueue;
    protected Vector movePointQueue;
    protected Vector moveTypeQueue;
    protected Animator blockAnimator;
    protected Vector actionQueue;
    protected Vector planVector;
    protected boolean planApplied;
    protected Gripper gripper;
    protected Point gripperHome;
    protected boolean gripperInitialized;
    protected int lastGripperCol;

    public BlockAnimatorCanvas(PlanningWindow parent, boolean inline, World world, BlockGraph initialGraph, BlockGraph goalGraph, int mode) {
        super(parent, inline, world);
        this.pause();
        this.mode = mode;
        this.world = world;
        this.puttingDown = false;
        this.animating = false;
        this.planApplied = false;
        this.gripperInitialized = false;
        this.lastGripperCol = 0;
        this.gripper = new Gripper(new Point(0.0f, 0.0f), 10);
        this.currPlanSteps = world.getPlan().size();
        this.moveBlockQueue = new Vector();
        this.movePointQueue = new Vector();
        this.moveTypeQueue = new Vector();
        this.actionQueue = new Vector();
        this.initialBlockGraph = initialGraph.pseudoCopy(this, world);
        if (goalGraph != null) {
            this.goalBlockGraph = goalGraph.pseudoCopy(this, world);
        }
        this.showInitialState();
        world.addListener(this);
    }

    public void reset(BlockGraph initialGraph, BlockGraph goalGraph) {
        if (this.blockAnimator != null) {
            this.blockAnimator.quit();
        }
        this.puttingDown = false;
        this.animating = false;
        this.planApplied = false;
        this.currPlanSteps = this.world.getPlan().size();
        this.moveBlockQueue = new Vector();
        this.movePointQueue = new Vector();
        this.moveTypeQueue = new Vector();
        this.actionQueue = new Vector();
        this.gripper.pos = new Point(this.gripperHome.x, this.gripperHome.y);
        this.initialBlockGraph = initialGraph.pseudoCopy(this, this.world);
        if (goalGraph != null) {
            this.goalBlockGraph = goalGraph.pseudoCopy(this, this.world);
        }
        this.graph = this.initialBlockGraph;
        this.showInitialState();
        this.repaint();
    }

    public void applyCurrentPlan() {
        this.planVector = this.world.getPlan();
        if (this.planVector.size() > 0) {
            int i = 0;
            while (i < this.planVector.size()) {
                this.actionQueue.addElement(this.planVector.elementAt(i));
                ++i;
            }
        }
        this.applyActions();
    }

    protected void applyAction(Atom actionAtom) {
        String actionName = actionAtom.getPredicate().getPredicateSymbol();
        if (actionName.equals("pickup")) {
            this.pickup(actionAtom.getTermAt(0).toString());
        } else if (actionName.equals("pickuptable")) {
            this.pickup(actionAtom.getTermAt(0).toString());
        } else if (actionName.equals("putdown")) {
            this.putdown(actionAtom.getTermAt(0).toString(), actionAtom.getTermAt(1).toString());
        } else if (actionName.equals("putdowntable")) {
            this.putdowntable(actionAtom.getTermAt(0).toString());
        }
    }

    protected void moveBlock() {
        if (this.moveBlockQueue.size() > 0 && !this.animating) {
            this.animating = true;
            AnimatedEntity block = (AnimatedEntity)this.moveBlockQueue.elementAt(0);
            Point point = (Point)this.movePointQueue.elementAt(0);
            int type = (Integer)this.moveTypeQueue.elementAt(0);
            this.moveBlockQueue.removeElementAt(0);
            this.movePointQueue.removeElementAt(0);
            this.moveTypeQueue.removeElementAt(0);
            this.puttingDown = type == 400;
            this.blockAnimator = type == 402 ? new Animator(this, block, point) : new Animator(this, block, point, this.gripper);
            this.blockAnimator.start();
        }
    }

    protected void queueMovement(AnimatedEntity block, Point newPoint, int type) {
        this.moveBlockQueue.addElement(block);
        this.movePointQueue.addElement(newPoint);
        this.moveTypeQueue.addElement(new Integer(type));
        this.moveBlock();
    }

    protected void pickup(String blockName) {
        BlockNode block = this.initialBlockGraph.getBlockByName(blockName);
        float maximumY = this.initialBlockGraph.getHighestBlockY(block.getColumn(), this.lastGripperCol, null) - (float)(block.height / 2) - (float)this.gripper.height;
        float horizMovementY = 0.0f;
        if (this.gripper.pos.y > maximumY) {
            this.queueMovement(this.gripper, new Point(this.gripper.pos.x, maximumY), 402);
            horizMovementY = maximumY;
        } else {
            horizMovementY = this.gripper.pos.y;
        }
        this.queueMovement(this.gripper, new Point(block.pos.x - (float)(block.width / 2), horizMovementY), 402);
        this.queueMovement(this.gripper, new Point(block.pos.x - (float)(block.width / 2), block.pos.y - (float)(block.height / 2) - (float)this.gripper.getHeight()), 402);
        Point newPoint = new Point(block.pos.x, block.pos.y - (float)block.height);
        this.queueMovement(block, newPoint, 401);
    }

    protected void putdowntable(String blockName) {
        BlockNode block = this.initialBlockGraph.getBlockByName(blockName);
        if (block == null) {
            System.out.println("ERROR in putdowntable, block is null: " + blockName);
        }
        BlockNode goalBlock = null;
        goalBlock = this.goalBlockGraph != null ? this.goalBlockGraph.getBlockByName(blockName) : null;
        int targetColumn = -1;
        if (goalBlock != null && this.initialBlockGraph.getBlock(goalBlock.getColumn(), 0) == null) {
            targetColumn = goalBlock.getColumn();
        }
        if (targetColumn == -1) {
            int rightPtr = block.getColumn() + 1;
            int leftPtr = block.getColumn() - 1;
            while (leftPtr > -1 || rightPtr < 7) {
                if (rightPtr < 7 && this.initialBlockGraph.getBlock(rightPtr, 0) == null) {
                    targetColumn = rightPtr;
                    break;
                }
                ++rightPtr;
                if (leftPtr > -1 && this.initialBlockGraph.getBlock(leftPtr, 0) == null) {
                    targetColumn = leftPtr;
                    break;
                }
                --leftPtr;
            }
        }
        if (targetColumn == -1) {
            return;
        }
        float maximumY = this.initialBlockGraph.getHighestBlockY(block.getColumn(), targetColumn, block) - (float)(block.height / 2) - (float)block.height;
        float horizMovementY = 0.0f;
        if (block.pos.y > maximumY) {
            this.queueMovement(block, new Point(block.pos.x, maximumY), 401);
            horizMovementY = maximumY;
        } else {
            horizMovementY = block.pos.y;
        }
        block.setStackHeight(0);
        block.setColumn(targetColumn);
        this.queueMovement(block, new Point(block.getGridX(), horizMovementY), 401);
        this.queueMovement(block, new Point(block.getGridX(), block.getGridY()), 400);
        this.queueMovement(this.gripper, new Point(block.getGridX() - (float)(block.width / 2), block.getGridY() - (float)(block.height / 2) - (float)(this.gripper.getHeight() * 2)), 402);
        this.lastGripperCol = block.getColumn();
    }

    protected void putdown(String blockName, String underBlockName) {
        BlockNode block = this.initialBlockGraph.getBlockByName(blockName);
        BlockNode underBlock = this.initialBlockGraph.getBlockByName(underBlockName);
        int targetColumn = underBlock.getColumn();
        block.setStackHeight(underBlock.getStackHeight() + 1);
        float maximumY = this.initialBlockGraph.getHighestBlockY(block.getColumn(), targetColumn, block) - (float)(block.height / 2) - (float)block.height;
        float horizMovementY = 0.0f;
        if (block.pos.y > maximumY) {
            this.queueMovement(block, new Point(block.pos.x, maximumY), 401);
            horizMovementY = maximumY;
        } else {
            horizMovementY = block.pos.y;
        }
        this.queueMovement(block, new Point(underBlock.pos.x, horizMovementY), 401);
        block.setColumn(targetColumn);
        this.queueMovement(block, new Point(underBlock.pos.x, block.getGridY()), 400);
        this.queueMovement(this.gripper, new Point(block.getGridX() - (float)(block.width / 2), block.getGridY() - (float)(block.height / 2) - (float)(this.gripper.getHeight() * 2)), 402);
        this.lastGripperCol = block.getColumn();
    }

    public void update() {
        if (this.usingStrips && this.mode == 300 && this.world.getPlan().size() > this.currPlanSteps) {
            this.actionQueue.addElement(this.world.getPlan().elementAt(this.world.getPlan().size() - 1));
            if (!this.animating) {
                this.applyActions();
            }
            this.currPlanSteps = this.world.getPlan().size();
        }
    }

    public void blockMoveComplete(AnimatedEntity block) {
        this.animating = false;
        this.blockAnimator = null;
        if (this.puttingDown) {
            block.setAnimating(false);
            this.repaint();
        }
        this.moveBlock();
        if (!this.animating && this.actionQueue.size() > 0) {
            this.applyActions();
        }
    }

    protected void applyActions() {
        if (this.actionQueue.size() > 0 && !this.animating) {
            Atom nextAction = (Atom)this.actionQueue.elementAt(0);
            this.actionQueue.removeElementAt(0);
            this.applyAction(nextAction);
        }
    }

    public void runPlan() {
        if (!this.animating && !this.planApplied) {
            this.planApplied = true;
            this.applyCurrentPlan();
        } else if (this.blockAnimator != null) {
            this.blockAnimator.setPaused(false);
        }
    }

    public void stop() {
        if (this.blockAnimator != null) {
            this.blockAnimator.setPaused(true);
        }
    }

    public void finalize() {
        if (this.blockAnimator != null) {
            this.blockAnimator.quit();
        }
        this.world.removeListener(this);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int xAdjust = 0;
        int yAdjust = 0;
        if (!this.gripperInitialized) {
            this.gripper.pos = new Point(xAdjust + 5, yAdjust + 5);
            this.gripperHome = new Point(this.gripper.pos.x, this.gripper.pos.y);
            this.gripperInitialized = true;
        }
        this.gripper.setWidth(Math.round(this.tableLength / 7));
        this.gripper.setPosAdjust(xAdjust, yAdjust);
        this.gripper.draw(g);
    }
}

