/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.PlannerCanvas;
import CIspace.planning.PlanningWindow;

public class AutoSolver
extends Thread {
    private int delayTime;
    private PlannerCanvas canvas;
    private PlanningWindow window;
    private boolean running;

    public AutoSolver(PlanningWindow window, PlannerCanvas canvas, int delayTime) {
        this.canvas = canvas;
        this.window = window;
        this.delayTime = delayTime;
        this.running = false;
    }

    public void run() {
        this.running = true;
        while (this.canvas.autoSolveContinue() && this.running) {
            this.canvas.step();
            try {
                Thread.sleep(this.delayTime);
            }
            catch (InterruptedException err) {
                System.out.println(err);
            }
        }
        this.window.autoSolveEnd();
    }

    public void quit() {
        this.running = false;
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    public boolean isRunning() {
        return this.running;
    }
}

