/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.DefiniteClause;
import CIspace.planning.Predicate;
import CIspace.planning.Term;
import CIspace.planning.Variable;
import java.util.Vector;

public class Atom
implements DefiniteClause {
    protected Predicate predicate;
    protected int numTerms;
    protected Vector terms;

    public Atom(Predicate predicate) {
        this.predicate = predicate;
        this.numTerms = predicate.getNumTerms();
        this.terms = new Vector(this.numTerms);
        int i = 0;
        while (i < this.numTerms) {
            this.terms.addElement(new Object());
            ++i;
        }
    }

    public void setTerm(int pos, Object term) {
        this.terms.setElementAt(term, pos);
    }

    public Term getTermAt(int pos) {
        return (Term)this.terms.elementAt(pos);
    }

    public String toString() {
        if (this.numTerms == 0) {
            return this.predicate.toString();
        }
        String stringRep = String.valueOf(this.predicate.toString()) + "(";
        int i = 0;
        while (i < this.numTerms) {
            stringRep = String.valueOf(stringRep) + this.terms.elementAt(i).toString();
            if (i != this.numTerms - 1) {
                stringRep = String.valueOf(stringRep) + ", ";
            }
            ++i;
        }
        stringRep = String.valueOf(stringRep) + ")";
        return stringRep;
    }

    public Atom copy(Vector variables) {
        Atom newAtom = new Atom((Predicate)this.predicate.clone());
        int i = 0;
        while (i < this.terms.size()) {
            Term currTerm = (Term)this.getTermAt(i).clone();
            if (currTerm.getType() == 100) {
                newAtom.setTerm(i, currTerm);
            } else {
                Variable foundVar = null;
                int j = 0;
                while (j < variables.size()) {
                    Variable currVar = (Variable)variables.elementAt(j);
                    if (currVar.getVarName().equals(currTerm.getVariable().getVarName())) {
                        foundVar = currVar;
                        break;
                    }
                    ++j;
                }
                if (foundVar == null) {
                    variables.addElement(currTerm.getVariable());
                    newAtom.setTerm(i, currTerm);
                } else {
                    newAtom.setTerm(i, new Term(foundVar));
                }
            }
            ++i;
        }
        return newAtom;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public int getNumTerms() {
        return this.numTerms;
    }

    public Vector getTerms() {
        return this.terms;
    }

    public int getClauseType() {
        return 500;
    }
}

