/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.graphToolKit.Point;
import CIspace.planning.AnimatedEntity;
import CIspace.planning.BlockAnimatorCanvas;

public class Animator
extends Thread {
    private static final int delayTime = 50;
    private static final int stepSize = 3;
    private boolean running;
    private boolean pause;
    private AnimatedEntity animEntity;
    private AnimatedEntity gripper;
    private Point newPosition;
    private BlockAnimatorCanvas client;

    public Animator(BlockAnimatorCanvas client, AnimatedEntity animEntity, Point newPosition) {
        this.animEntity = animEntity;
        this.client = client;
        this.newPosition = newPosition;
        this.running = false;
        animEntity.setAnimating(true);
        this.pause = false;
        this.gripper = null;
    }

    public Animator(BlockAnimatorCanvas client, AnimatedEntity animEntity, Point newPosition, AnimatedEntity gripper) {
        this.animEntity = animEntity;
        this.client = client;
        this.newPosition = newPosition;
        this.running = false;
        animEntity.setAnimating(true);
        this.pause = false;
        this.gripper = gripper;
    }

    public void run() {
        this.running = true;
        float targetX = this.newPosition.x;
        float targetY = this.newPosition.y;
        while (this.running) {
            if (!this.pause) {
                float currX = this.animEntity.getPos().x;
                float currY = this.animEntity.getPos().y;
                if (Math.abs(targetX - currX) < 3.0f) {
                    if (this.gripper != null) {
                        this.gripper.getPos().x += targetX - currX;
                    }
                    this.animEntity.getPos().x = targetX;
                } else if (targetX > currX) {
                    if (this.gripper != null) {
                        this.gripper.getPos().x += 3.0f;
                    }
                    this.animEntity.getPos().x += 3.0f;
                } else {
                    if (this.gripper != null) {
                        this.gripper.getPos().x -= 3.0f;
                    }
                    this.animEntity.getPos().x -= 3.0f;
                }
                if (Math.abs(targetY - currY) < 3.0f) {
                    if (this.gripper != null) {
                        this.gripper.getPos().y += targetY - currY;
                    }
                    this.animEntity.getPos().y = targetY;
                } else if (targetY > currY) {
                    if (this.gripper != null) {
                        this.gripper.getPos().y += 3.0f;
                    }
                    this.animEntity.getPos().y += 3.0f;
                } else {
                    if (this.gripper != null) {
                        this.gripper.getPos().y -= 3.0f;
                    }
                    this.animEntity.getPos().y -= 3.0f;
                }
                if (currX == targetX && currY == targetY) {
                    this.running = false;
                    this.client.blockMoveComplete(this.animEntity);
                    return;
                }
                this.client.repaint();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException err) {
                System.out.println(err);
            }
        }
    }

    public void setPaused(boolean isPaused) {
        this.pause = isPaused;
    }

    public void quit() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }
}

