/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.Atom;
import CIspace.planning.BlockNode;
import CIspace.planning.DialogAdapter;
import CIspace.planning.Predicate;
import CIspace.planning.Term;
import CIspace.planning.Variable;
import CIspace.planning.VariableInputDialog;
import CIspace.planning.World;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AddGoalDialog
extends DialogAdapter
implements ItemListener {
    protected World world;
    protected JFrame window;
    protected JComboBox predicateChoice;
    protected int numTerms;
    protected JPanel termPanel;
    protected JButton addButton;
    protected Vector termChoiceVector;
    protected Vector availableBlocks;

    public AddGoalDialog(JFrame parent, World world, Vector blockNames) {
        super(parent, "Add New Goal", true);
        this.world = world;
        this.window = parent;
        this.termChoiceVector = new Vector();
        this.availableBlocks = blockNames;
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 10;
        this.gbc.fill = 1;
        this.termPanel = new JPanel();
        this.constructDialog();
        this.processPredicateSelection((String)this.predicateChoice.getSelectedItem());
        this.pack();
        ((Component)this).setSize(325, 150);
        this.centerWindow();
        this.show();
    }

    protected void constructDialog() {
        JPanel mainPanel = new JPanel();
        this.predicateChoice = new JComboBox();
        this.predicateChoice.addItemListener(this);
        Vector predicates = this.world.getPredicateSet();
        int i = 0;
        while (i < predicates.size()) {
            this.predicateChoice.addItem(((Predicate)predicates.elementAt(i)).getPredicateSymbol());
            ++i;
        }
        this.termPanel.setLayout(new BorderLayout());
        this.addComponent(new JLabel("Select a predicate:"), mainPanel, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.predicateChoice, mainPanel, 0, 1, 1, 1, 1.0, 1.0);
        this.addComponent(new JLabel("Enter Terms:"), mainPanel, 1, 0, 2, 1, 1.0, 1.0);
        this.addComponent(this.termPanel, mainPanel, 2, 0, 2, 1, 1.0, 1.0);
        this.addComponent(this.makeButtonPanel(), mainPanel, 3, 0, 2, 1, 1.0, 1.0);
        mainPanel.setLayout(this.gbl);
        this.getContentPane().add(mainPanel);
    }

    protected JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        this.addButton = new JButton("Add Goal");
        this.addButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        buttonPanel.add(this.addButton);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    protected void processPredicateSelection(String predicateSymbol) {
        this.termPanel.removeAll();
        this.numTerms = this.getNumTerms(predicateSymbol);
        this.termChoiceVector = new Vector();
        Vector existingVars = this.world.getGoalStateVariableNames();
        this.repaint();
        if (this.numTerms == 0) {
            this.termPanel.setLayout(new FlowLayout());
            this.termPanel.add(new JLabel("(No terms required for this predicate)"));
            this.termPanel.validate();
            return;
        }
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        int currCol = 0;
        this.addComponent(new JLabel(String.valueOf(predicateSymbol) + "(   "), this.termPanel, 0, currCol++, 1, 1, 0.0, 0.0);
        int i = 0;
        while (i < this.numTerms) {
            JComboBox<String> termChoice = new JComboBox<String>();
            termChoice.addItemListener(this);
            int j = 0;
            while (j < this.availableBlocks.size()) {
                termChoice.addItem(((BlockNode)this.availableBlocks.elementAt(j)).toString());
                ++j;
            }
            j = 0;
            while (j < existingVars.size()) {
                termChoice.addItem((String)existingVars.elementAt(j));
                ++j;
            }
            termChoice.addItem("<Variable>");
            this.termChoiceVector.addElement(termChoice);
            this.addComponent(termChoice, this.termPanel, 0, currCol++, 1, 1, 0.0, 0.0);
            if (i < this.numTerms - 1) {
                this.addComponent(new JLabel(" , "), this.termPanel, 0, currCol++, 1, 1, 0.0, 0.0);
            }
            ++i;
        }
        this.termPanel.setFont(new Font("arial", 0, 12));
        this.termPanel.setLayout(this.gbl);
        this.addComponent(new JLabel("   )"), this.termPanel, 0, currCol++, 1, 1, 0.0, 0.0);
        this.termPanel.validate();
        ((JComboBox)this.termChoiceVector.elementAt(0)).requestFocus();
    }

    protected boolean processAddGoal() {
        Predicate newGoalPredicate = new Predicate((String)this.predicateChoice.getSelectedItem(), this.numTerms);
        Atom newGoalAtom = new Atom(newGoalPredicate);
        int i = 0;
        while (i < this.termChoiceVector.size()) {
            Term currTerm = null;
            JComboBox currTermChoice = (JComboBox)this.termChoiceVector.elementAt(i);
            String termText = (String)currTermChoice.getSelectedItem();
            if (!termText.equals("<Variable>")) {
                String firstChar = termText.substring(0, 1);
                if (firstChar.equals(firstChar.toLowerCase())) {
                    int j = 0;
                    while (j < this.availableBlocks.size()) {
                        BlockNode currBlock = (BlockNode)this.availableBlocks.elementAt(j);
                        if (currBlock.toString().equals(termText)) {
                            currTerm = new Term(currBlock);
                        }
                        ++j;
                    }
                } else {
                    Variable existingVar = this.world.getGoalStateVariable(termText);
                    if (existingVar != null) {
                        currTerm = new Term(existingVar);
                    } else {
                        Variable currTermVariable = new Variable(termText);
                        currTerm = new Term(currTermVariable);
                    }
                }
            } else {
                return false;
            }
            newGoalAtom.setTerm(i, currTerm);
            ++i;
        }
        this.world.addStateItem(newGoalAtom, 201);
        return true;
    }

    protected int getNumTerms(String predicateSymbol) {
        Vector predicates = this.world.getPredicateSet();
        int i = 0;
        while (i < predicates.size()) {
            Predicate currPred = (Predicate)predicates.elementAt(i);
            if (predicateSymbol.equals(currPred.getPredicateSymbol())) {
                return currPred.numTerms;
            }
            ++i;
        }
        return -1;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Cancel") {
            this.hide();
        } else if (e.getActionCommand() == "Add Goal" && this.processAddGoal()) {
            this.hide();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object itemChanged = e.getSource();
        if (itemChanged == this.predicateChoice) {
            String selection = (String)((JComboBox)itemChanged).getSelectedItem();
            this.processPredicateSelection(selection);
        } else {
            VariableInputDialog vid;
            String input;
            JComboBox currChoice = (JComboBox)itemChanged;
            String selection = (String)currChoice.getSelectedItem();
            if (selection.equals("<Variable>") && !(input = (vid = new VariableInputDialog(this.window)).getInput()).equals("")) {
                int i = 0;
                while (i < currChoice.getItemCount()) {
                    String currItem = (String)currChoice.getItemAt(i);
                    if (currItem.equals(input)) {
                        currChoice.setSelectedIndex(i);
                        return;
                    }
                    ++i;
                }
                currChoice.insertItemAt(input, 0);
                currChoice.validate();
                currChoice.setSelectedIndex(0);
            }
        }
    }
}

