/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.Atom;
import CIspace.planning.Term;
import CIspace.planning.Variable;
import java.util.Vector;

public class Action {
    protected String name;
    protected int numTerms;
    protected Vector terms;
    protected Vector preconditions;
    protected Vector addList;
    protected Vector deleteList;

    public Action(String name, int numTerms) {
        this.name = name;
        this.numTerms = numTerms;
        this.preconditions = new Vector();
        this.addList = new Vector();
        this.deleteList = new Vector();
        this.terms = new Vector(numTerms);
        int i = 0;
        while (i < numTerms) {
            this.terms.addElement(new Object());
            ++i;
        }
    }

    public void setTerm(int pos, Term term) {
        this.terms.setElementAt(term, pos);
    }

    public Action copy() {
        Vector<Variable> variables = new Vector<Variable>();
        Action newAction = new Action(new String(this.name), this.numTerms);
        int i = 0;
        while (i < this.terms.size()) {
            Term currTerm = (Term)this.getTermAt(i).clone();
            if (currTerm.getType() == 100) {
                newAction.setTerm(i, currTerm);
            } else {
                Variable foundVar = null;
                int j = 0;
                while (j < variables.size()) {
                    Variable currVar = (Variable)variables.elementAt(j);
                    if (currVar.getVarName().equals(currTerm.getVariable().getVarName())) {
                        foundVar = currVar;
                        break;
                    }
                    ++j;
                }
                if (foundVar == null) {
                    variables.addElement(currTerm.getVariable());
                    newAction.setTerm(i, currTerm);
                } else {
                    newAction.setTerm(i, new Term(foundVar));
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.preconditions.size()) {
            newAction.preconditions.addElement(((Atom)this.preconditions.elementAt(i)).copy(variables));
            ++i;
        }
        i = 0;
        while (i < this.addList.size()) {
            newAction.addList.addElement(((Atom)this.addList.elementAt(i)).copy(variables));
            ++i;
        }
        i = 0;
        while (i < this.deleteList.size()) {
            newAction.deleteList.addElement(((Atom)this.deleteList.elementAt(i)).copy(variables));
            ++i;
        }
        return newAction;
    }

    public String getStringRep() {
        if (this.terms.size() == 0) {
            return this.name;
        }
        String value = String.valueOf(this.name) + "(";
        int i = 0;
        while (i < this.terms.size()) {
            value = String.valueOf(value) + ((Term)this.terms.elementAt(i)).toString();
            if (i < this.terms.size() - 1) {
                value = String.valueOf(value) + ", ";
            }
            ++i;
        }
        value = String.valueOf(value) + ")";
        return value;
    }

    public Term getTermAt(int pos) {
        return (Term)this.terms.elementAt(pos);
    }

    public void addPrecondition(Atom precondition) {
        this.preconditions.addElement(precondition);
    }

    public void addAddListItem(Atom addListItem) {
        this.addList.addElement(addListItem);
    }

    public void addDeleteListItem(Atom deleteListItem) {
        this.deleteList.addElement(deleteListItem);
    }

    public Vector getPreconditions() {
        return this.preconditions;
    }

    public Vector getAddList() {
        return this.addList;
    }

    public Vector getDeleteList() {
        return this.deleteList;
    }

    public String getName() {
        return this.name;
    }

    public int getNumTerms() {
        return this.numTerms;
    }

    public String toString() {
        return this.name;
    }
}

