/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.AboutBox;
import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpMenu
extends JMenu
implements ActionListener {
    private static final String helpURL = "http://www.cs.ubc.ca/labs/lci/CIspace/CIspaceWebDev/CIspace/";
    private static final String localHelp = "help";
    private static final String aboutCIspaceURL = "http://www.cs.ubc.ca/labs/lci/CIspace/";
    private static final String notAppletMessage = "To access help, please open a browser to the following URL: ";
    private String appletName;
    private JApplet applet;
    private JFrame parent;
    private JEditorPane htmlPane;

    public HelpMenu(JApplet applet, String name, JFrame parent) {
        super("Help");
        this.applet = applet;
        this.appletName = name;
        this.parent = parent;
        JMenuItem mi = new JMenuItem("Help");
        this.add(mi);
        mi.addActionListener(this);
        this.addSeparator();
        mi = new JMenuItem("About CIspace");
        this.add(mi);
        mi.addActionListener(this);
        mi = new JMenuItem("About this applet");
        this.add(mi);
        mi.addActionListener(this);
    }

    public void openBrowserHelp(String helptype) {
        String urlString = helpURL + this.appletName + "/" + localHelp + "/" + helptype;
        if (this.applet != null) {
            AppletContext ac = this.applet.getAppletContext();
            try {
                URL url = new URL(urlString);
                ac.showDocument(url, "_blank");
            }
            catch (Exception e) {
                System.err.println("Error URL malformed: " + urlString);
            }
        } else {
            MyEditor myEditor = new MyEditor();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Help") {
            this.openBrowserHelp("index.html");
        } else if (e.getActionCommand() == "About CIspace") {
            new AboutBox(this.parent, true);
        } else if (e.getActionCommand() == "About this applet") {
            new AboutBox(this.parent, false);
        }
    }

    class MyEditor
    extends JFrame
    implements HyperlinkListener {
        public MyEditor() {
            super("Help");
            try {
                HelpMenu.this.htmlPane = new JEditorPane();
                HelpMenu.this.htmlPane.addHyperlinkListener(this);
                HelpMenu.this.htmlPane.setPage(HelpMenu.aboutCIspaceURL + HelpMenu.this.appletName + "/help/");
                HelpMenu.this.htmlPane.setEditable(false);
                JScrollPane htmlView = new JScrollPane(HelpMenu.this.htmlPane);
                Dimension minimumSize = new Dimension(500, 500);
                htmlView.setMinimumSize(minimumSize);
                this.getContentPane().add((Component)htmlView, "Center");
                ((Component)this).setSize(800, 800);
                this.show();
            }
            catch (IOException e) {
                System.err.println("Error URL null or cannot be accessed: " + e.toString());
            }
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    HelpMenu.this.htmlPane.setPage(e.getURL());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

