/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.AboutCanvas;
import CIspace.graphToolKit.GraphWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AboutBox
extends JDialog
implements ActionListener,
WindowListener {
    private AboutCanvas canvas;
    private static String aboutText = "About CIspace Applets\n\nThis applet is part of a series of CIspace applets intended to\nteach fundamental algorithms from the field of computational\nintelligence. It was produced at the Laboratory for Computational\nIntelligence at the University of British Columbia.\n\nThese applets were designed and written by Leslie Tung,\nKevin O'Neill, Mike Cline, Shinjiro Sueda, Alan Mackworth\nand David Poole.\nThese applets were updated by Nicole Arksey and Saleema Amershi.\nCopyright (c) 1999 - 2003,\n Mackworth, Poole, Cline, O'Neill, Sueda, and Tung\n\nContact information:\n\nDavid Poole - poole@cs.ubc.ca\nAlan Mackworth - mack@cs.ubc.ca\n\nFor more information about the CIspace project, or to try other\nCIspace applets, go to http://www.cs.ubc.ca/labs/lci/CIspace\n\nThe CIspace algorithms teach algorithms from the textbook\n`Computational Intelligence' by Poole, Mackworth, Goebel.\nFor more information about the text, see\nhttp://www.cs.ubc.ca/spider/poole/ci.html";

    public AboutBox(JFrame parent, boolean gtk) {
        super(parent, "About", true);
        this.addWindowListener(this);
        ((Component)this).setSize(450, 400);
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JTextArea canvas = new JTextArea(50, 50);
        if (gtk) {
            canvas.setText(aboutText);
        } else {
            canvas.setText(((GraphWindow)parent).getAboutText());
        }
        canvas.setEditable(false);
        JButton ok = new JButton("OK");
        ok.addActionListener(this);
        canvas.setCaretPosition(0);
        JScrollPane textScroll = new JScrollPane(canvas, 20, 30);
        contentPane.add("Center", textScroll);
        contentPane.add("South", ok);
        this.centerWindow();
        this.show();
    }

    private void centerWindow() {
        Container parent = this.getParent();
        int midX = parent.getLocationOnScreen().x + parent.getSize().width / 2;
        int midY = parent.getLocationOnScreen().y + parent.getSize().height / 2;
        ((Component)this).setLocation(midX - this.getSize().width / 2, midY - this.getSize().height / 2);
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("OK")) {
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.canvas.stop();
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

