/*
 * Decompiled with CFR 0.152.
 */
package CIspace.XMLReader;

import CIspace.XMLReader.Pair;
import java.util.Vector;

public class XMLBlock {
    private String text;
    private String tagName;
    private Vector properties;
    public Vector childBlocks;

    public XMLBlock() {
        this.text = "";
        this.tagName = "";
        this.properties = new Vector();
        this.childBlocks = new Vector();
    }

    public XMLBlock(String t, String name, Vector prop, Vector children) {
        this.text = t;
        this.tagName = name;
        this.properties = (Vector)prop.clone();
        this.childBlocks = (Vector)children.clone();
    }

    public XMLBlock(XMLBlock original) {
        this.text = original.text;
        this.tagName = original.text;
        this.properties = (Vector)original.properties.clone();
        this.childBlocks = (Vector)original.childBlocks.clone();
    }

    public String getText() {
        return this.text;
    }

    public String getTag() {
        return this.tagName;
    }

    public Vector getProperties() {
        return this.properties;
    }

    public void setText(String t) {
        this.text = t;
    }

    public void setTag(String tag) {
        this.tagName = tag;
    }

    public void addProperty(String propertyName, String propertyValue) {
        Pair pair = new Pair();
        pair.name = propertyName;
        pair.value = propertyValue;
        this.properties.addElement(pair);
    }

    public void addChild(XMLBlock child) {
        this.childBlocks.addElement(child);
    }

    public boolean removeChild(String name) {
        int i = 0;
        while (i < this.childBlocks.size()) {
            if (name == ((XMLBlock)this.childBlocks.elementAt((int)i)).tagName) {
                this.childBlocks.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vector searchChildTag(String tag) {
        Vector<XMLBlock> searchResults = new Vector<XMLBlock>();
        int i = 0;
        while (i < this.childBlocks.size()) {
            XMLBlock currBlock = (XMLBlock)this.childBlocks.elementAt(i);
            if (currBlock.tagName.equalsIgnoreCase(tag)) {
                searchResults.addElement(currBlock);
            }
            ++i;
        }
        if (searchResults.size() > 0) {
            return searchResults;
        }
        return null;
    }
}

